package org.msh.etbm.services.mobile;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.msh.etbm.commons.Item;
import org.msh.etbm.rest.authentication.AuthenticationForm;
import org.msh.etbm.rest.exceptions.UnauthorizedException;
import org.msh.etbm.services.auth.AuthenticationService;
import org.msh.tb.entities.AdministrativeUnit;
import org.msh.tb.entities.UserWorkspace;
import org.msh.tb.login.UserSession;

import javax.persistence.EntityManager;

/**
 * Created by rmemoria on 7/5/17.
 */
@Name("mobileLoginService")
@Scope(ScopeType.APPLICATION)
@AutoCreate
public class MobileLoginService {

    @In(create = true)
    AuthenticationService authenticationService;

    @In
    EntityManager entityManager;


    /**
     * Perform a user authentication and return session and other information necessary
     * for mobile users
     * @param form instance of {@link AuthenticationForm}
     * @return
     */
    public MobileLoginResponse login(AuthenticationForm form) {
        String token = authenticationService.login(form.getLogin(), form.getPassword(), form.getWorkspace());

        if (token == null) {
            throw new UnauthorizedException();
        }

        MobileLoginResponse resp = new MobileLoginResponse();
        resp.setAuthToken(token);

        UserWorkspace uw = UserSession.getUserWorkspace();

        resp.setName(uw.getUser().getName());

        Item<Integer> unit = new Item<Integer>(uw.getTbunit().getId(), uw.getTbunit().getName().getName1());
        resp.setUnit(unit);

        resp.setNotifyTB(uw.getTbunit().isTbHealthUnit());
        resp.setNotifyDRTB(uw.getTbunit().isMdrHealthUnit());
        resp.setNotifyNTM(uw.getTbunit().isNtmHealthUnit());

        Item<Integer> workspace = new Item<Integer>(uw.getWorkspace().getId(), uw.getWorkspace().getName().getName1());
        resp.setWorkspace(workspace);

        AdministrativeUnit au = uw.getTbunit().getAdminUnit();
        Item<Integer> adminUnit = new Item<Integer>(au.getId(), au.getFullDisplayName());
        resp.setAdminUnit(adminUnit);

        // the server index used by the mobile to avoid get data not being referenced
        resp.setServerIndex(calcLastTransaction());

        return resp;
    }

    /**
     * Calculate the maximum transaction ID to be used as an index for next synchronizations
     * from the client side (mobile)
     * @return the maximum ID
     */
    public Integer calcLastTransaction() {
        Number res = (Number)entityManager
                .createQuery("select max(id) from TransactionLog")
                .getSingleResult();

        return res.intValue();
    }
}
